/*
 * Diese Datei ist Teil des GDialog Projektes:
 * "Gigaset-Erweiterung fr ProjectX"
 * 
 * Das GDialog Projekt ist freigegeben unter
 * der GNU Public Licence (GPL), deren Text sich in
 * dem Quellen-Verzeichnis befindet. Ist er dort nicht
 * mehr vorhanden, so kann er unter http://www.gnu.org/licenses/gpl.html
 * eingesehen werden.
 */
package de.m740.projectx.gigaset;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

import net.sourceforge.dvb.projectx.common.Common;

/**
 * 30.01.2005
 * 
 * @author Hans
 */
public abstract class GAufnahmeAbstract implements GAufnahmeIF {

    /** A list of event listeners for this object. */
    protected EventListenerList aListenerList = null;

    protected String cridFilename;

    protected long anzahlByte = -1;
    
    protected int aAnzahlMPGsErwartet = -1;

    protected int aAnzahlMPGsVorhanden = -1;

    protected int aAnzahlFMPGsErwartet = -1;

    protected int aAnzahlFMPGsVorhanden = -1;

    protected int status;

    protected int startZeitInSek;

    protected int endeZeitInSek;

    protected int gesperrt;

    protected int aSerienID = 0;

    protected String titel;

    protected int aFolgeNr = 0;

    protected boolean aIsSerie = false;

    protected String dateiNamenBasen[];

    protected int aufnahmeBeginnInSek;

    protected String info;

    protected String inhalt;

    protected int gesehenBisInSek;
    
    protected String aSender = null;
    
    protected boolean aValid = false;

    /*
     * (Kein Javadoc)
     * 
     * @see de.m740.projectx.gigaset.GAufnahmeIF#getStatus()
     */
    public int getStatus() {
        return status;
    }

    /*
     * (Kein Javadoc)
     * 
     * @see de.m740.projectx.gigaset.GAufnahmeIF#getStartzeit()
     */
    public int getStartzeit() {
        return startZeitInSek;
    }

    private Calendar getZeitAsCalendar(int inpZeitInSek) {
        Date tmpDate = new Date((long) inpZeitInSek * 1000);
        GregorianCalendar tmpGreg = new GregorianCalendar();
        tmpGreg.setTime(tmpDate);
        return tmpGreg;
    }

    protected Calendar getStartzeitAsCalendar() {
        return getZeitAsCalendar(getStartzeit());
    }

    /*
     * (Kein Javadoc)
     * 
     * @see de.m740.projectx.gigaset.GAufnahmeIF#getEndezeit()
     */
    public int getEndezeit() {
        return endeZeitInSek;
    }

    protected Calendar getEndezeitAsCalendar() {
        return getZeitAsCalendar(getEndezeit());
    }

    protected String calToString1(Calendar inpDate) {
        if (inpDate == null) {
            return "";
        }
        String tmpFmt = GDialog.getDateFormat1();
        if (tmpFmt == null || tmpFmt.length() == 0) {
            return "";
        }
        return GDialog.getSimpleDateFormat1().format(inpDate.getTime());
    }

    protected String calToString2(Calendar inpDate) {
        if (inpDate == null) {
            return "";
        }
        String tmpFmt = GDialog.getDateFormat2();
        if (tmpFmt == null || tmpFmt.length() == 0) {
            return "";
        }
        return GDialog.getSimpleDateFormat2().format(inpDate.getTime());
    }

    protected String getAufnahmezeitAsString() {
        StringBuffer tmpBuf = new StringBuffer();
        tmpBuf.append(calToString1(getStartzeitAsCalendar()));
        tmpBuf.append(calToString2(getEndezeitAsCalendar()));
        return tmpBuf.toString();
    }

    /*
     * (Kein Javadoc)
     * 
     * @see de.m740.projectx.gigaset.GAufnahmeIF#istGesperrt()
     */
    public boolean istGesperrt() {
        if (gesperrt == 1)
            return true;
        return false;
    }

    /*
     * (Kein Javadoc)
     * 
     * @see de.m740.projectx.gigaset.GAufnahmeIF#getTitel()
     */
    public String getTitel() {
        return toString();
    }

    public String getOriginalTitel() {
        return titel;
    }

    /*
     * (Kein Javadoc)
     * 
     * @see de.m740.projectx.gigaset.GAufnahmeIF#getExtension()
     */
    public String getExtension() {
        return EXTENSION;
    }

    /*
     * (Kein Javadoc)
     * 
     * @see de.m740.projectx.gigaset.GAufnahmeIF#getDateinamenBasen()
     */
    public String[] getDateinamenBasen() {
        return dateiNamenBasen;
    }

    /*
     * (Kein Javadoc)
     * 
     * @see de.m740.projectx.gigaset.GAufnahmeIF#getAufnahmeBeginn()
     */
    public int getAufnahmeBeginn() {
        return aufnahmeBeginnInSek;
    }

    /*
     * (Kein Javadoc)
     * 
     * @see de.m740.projectx.gigaset.GAufnahmeIF#getInfo()
     */
    public String getInfo() {
        return info;
    }

    /*
     * (Kein Javadoc)
     * 
     * @see de.m740.projectx.gigaset.GAufnahmeIF#getInhalt()
     */
    public String getInhalt() {
        return inhalt;
    }

    /*
     * (Kein Javadoc)
     * 
     * @see de.m740.projectx.gigaset.GAufnahmeIF#getGesehenBis()
     */
    public int getGesehenBis() {
        return gesehenBisInSek;
    }

    /*
     * (Kein Javadoc)
     * 
     * @see de.m740.projectx.gigaset.GAufnahmeIF#getByte()
     */
    public long getByte() {
        return anzahlByte;
    }

    /*
     * (Kein Javadoc)
     * 
     * @see de.m740.projectx.gigaset.GAufnahmeIF#getCridFilename()
     */
    public String getCridFilename() {
        return cridFilename;
    }

    /*
     * (Kein Javadoc)
     * 
     * @see de.m740.projectx.gigaset.GAufnahmeIF#toString()
     */
    public String toString() {
        StringBuffer tmpBuf = new StringBuffer(titel);
        boolean ok1 = Common.getSettings().getBooleanProperty(
                GDialog.PROPERTY_DATE_ALL, false);
        if (ok1 || aIsSerie) {
            boolean ok2 = ok1 ? false : Common.getSettings()
                    .getBooleanProperty(GDialog.PROPERTY_DATE_DOUBLES, false);
            if (ok1 || (ok2 && aIsSerie)) {
                tmpBuf.append(getAufnahmezeitAsString());
            } else {
                tmpBuf.append(" (");
                tmpBuf.append(aFolgeNr);
                tmpBuf.append(')');
            }
        }
        return tmpBuf.toString();
    }

    public abstract List getMpgFiles();

    /**
     * @return folgeNr
     */
    public int getFolgeNr() {
        return aFolgeNr;
    }

    /**
     * @param inpFolgeNr
     *            Festzulegender folgeNr
     */
    public void setFolgeNr(int inpFolgeNr) {
        aFolgeNr = inpFolgeNr;
    }

    /*
     * (Kein Javadoc)
     * 
     * @see de.m740.projectx.gigaset.GAufnahmeIF#isFolge()
     */
    public boolean isSerie() {
        return aIsSerie;
    }

    /*
     * (Kein Javadoc)
     * 
     * @see de.m740.projectx.gigaset.GAufnahmeIF#setFolge(boolean)
     */
    public void setSerie(boolean inpB) {
        aIsSerie = inpB;
    }

    /**
     * @return anzahlMPGs
     */
    public int getAnzahlMPGsErwartet() {
        return aAnzahlMPGsErwartet;
    }

    /**
     * @return anzahlMPGsVorhanden
     */
    public int getAnzahlMPGsVorhanden() {
        return aAnzahlMPGsVorhanden;
    }

    /**
     * @param inpAnzahlMPGsErwartet Festzulegender anzahlMPGsErwartet
     */
    protected void setAnzahlMPGsErwartet(int inpAnzahlMPGsErwartet) {
        aAnzahlMPGsErwartet = inpAnzahlMPGsErwartet;
    }

    /**
     * @param inpAnzahlMPGsVorhanden Festzulegender anzahlMPGsVorhanden
     */
    protected void setAnzahlMPGsVorhanden(int inpAnzahlMPGsVorhanden) {
        aAnzahlMPGsVorhanden = inpAnzahlMPGsVorhanden;
    }

    /**
     * Adds a <code>ChangeListener</code> to this tabbedpane.
     * 
     * @param l
     *            the <code>ChangeListener</code> to add
     * @see #fireStateChanged
     * @see #removeChangeListener
     */
    public void addChangeListener(ChangeListener l) {
        removeChangeListener(l); // prevent double listening!
        getListenerList().add(ChangeListener.class, l);
    }

    /**
     * Removes a <code>ChangeListener</code> from this tabbedpane.
     * 
     * @param l
     *            the <code>ChangeListener</code> to remove
     * @see #fireStateChanged
     * @see #addChangeListener
     */
    public void removeChangeListener(ChangeListener l) {
        getListenerList().remove(ChangeListener.class, l);
    }

    /**
     * Sends a <code>ChangeEvent</code>, whose source is this tabbedpane, to
     * each listener. This method method is called each time a
     * <code>ChangeEvent</code> is received from the model.
     * 
     * @see #addChangeListener
     * @see EventListenerList
     */
    protected void fireStateChanged() {
        // Guaranteed to return a non-null array
        Object[] listeners = getListenerList().getListenerList();
        // Process the listeners last to first, notifying
        // those that are interested in this event
        ChangeEvent tmpChangeEvent = null;
        int anz = (listeners == null) ? 0 : listeners.length;
        for (int i = anz - 2; i >= 0; i -= 2) {
            if (listeners[i] == ChangeListener.class) {
                // Lazily create the event:
                if (tmpChangeEvent == null)
                    tmpChangeEvent = new ChangeEvent(this);
                ((ChangeListener) listeners[i + 1])
                        .stateChanged(tmpChangeEvent);
            }
        }
    }

    /**
     * @return listenerList
     */
    protected EventListenerList getListenerList() {
        if (aListenerList == null) {
            aListenerList = new EventListenerList();
        }
        return aListenerList;
    }

    /* (Kein Javadoc)
     * @see de.m740.projectx.gigaset.GAufnahmeIF#isFehlerhaft()
     */
    public boolean isFehlerhaft() {
        if (anzahlByte == 0) {
            return true;
        }
        if (aAnzahlFMPGsErwartet != aAnzahlFMPGsVorhanden) {
            return true;
        }
        if (aAnzahlMPGsErwartet != aAnzahlMPGsVorhanden) {
            return true;
        }
        return false;
    }

    /**
     * @return anzahlFMPGsErwartet
     */
    public int getAnzahlFMPGsErwartet() {
        return aAnzahlFMPGsErwartet;
    }

    /**
     * @return anzahlFMPGsVorhanden
     */
    public int getAnzahlFMPGsVorhanden() {
        return aAnzahlFMPGsVorhanden;
    }

    /**
     * @param inpAnzahlFMPGsErwartet Festzulegender anzahlFMPGsErwartet
     */
    protected void setAnzahlFMPGsErwartet(int inpAnzahlFMPGsErwartet) {
        aAnzahlFMPGsErwartet = inpAnzahlFMPGsErwartet;
    }

    /**
     * @param inpAnzahlFMPGsVorhanden Festzulegender anzahlFMPGsVorhanden
     */
    protected void setAnzahlFMPGsVorhanden(int inpAnzahlFMPGsVorhanden) {
        aAnzahlFMPGsVorhanden = inpAnzahlFMPGsVorhanden;
    }

    /* (Kein Javadoc)
     * @see de.m740.projectx.gigaset.GAufnahmeIF#isLaufend()
     */
    public boolean isLaufend() {
        return (getStatus() == 2);
    }

    /**
     * @return valid
     */
    public boolean isValid() {
        return aValid;
    }

    /**
     * @param inpValid Festzulegender valid
     */
    protected void setValid(boolean inpValid) {
        aValid = inpValid;
    }

    public String getSender() {
        return aSender;
    }

    protected void setSender(String inpSendernamen) {
        aSender = inpSendernamen;
    }

    /**
     * @return serienID
     */
    public int getSerienID() {
        return aSerienID;
    }

}
